/**********************************************************************
 *
 * File :     rprandom.h
 *
 * Abstract : Random Number Generator
 *
 **********************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd. or
 * Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. will not, under any
 * circumstances, be liable for any lost revenue or other damages arising
 * from the use of this file.
 *
 * Copyright (c) 1998 Criterion Software Ltd.
 * All Rights Reserved.
 *
 * RenderWare is a trademark of Canon Inc.
 *
 ************************************************************************/

#ifndef RPRANDOMCLASS_H
#define RPRANDOMCLASS_H

/**
 * \defgroup rprandom RpRandom
 * \ingroup rpplugin
 *
 * Random Number Generation Plug-In for RenderWare.
 */

/*--- Include files ---*/
#include "rwcore.h"

/*--- Plugin API Functions ---*/

#define RPRANDMAX (~((~0)<<31))

class RpRandomClass
{
private:
    RwUInt32 *randomTable;
    RwUInt32 *fptr;
    RwUInt32 *rptr;
    RwUInt32 *end_ptr;
public:
    RpRandomClass();
    ~RpRandomClass();
    RwUInt32 Random(void);
    RwReal Random(RwReal);
    void RandomSeed(RwUInt32 seed);
};
#endif /* RPRANDOMCLASS_H */

